<?php
/* -----------------------------------------------------------------------------------------
   $Id: manufacturers.php 9 2011-02-22 15:43:59Z akausch $

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on:
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(manufacturers.php,v 1.18 2003/02/10); www.oscommerce.com
   (c) 2003	 nextcommerce (manufacturers.php,v 1.9 2003/08/17); www.nextcommerce.org

   Released under the GNU General Public License
   ---------------------------------------------------------------------------------------*/

$box_smarty = new smarty;

$box_smarty->assign('language', $_SESSION['language']);

//eingefgte Variable um in split_page_results.php unterscheiden zu knnen:
$_SESSION["MANUFACTURES_SORTBOX_IS_IN_USE"] = true;
$url = FILENAME_DEFAULT;
if (!CacheCheck())
{
	$cache = false;
	$box_smarty->caching = 0;
}
else
{
	$cache = true;
	$box_smarty->caching = 1;
	$box_smarty->cache_lifetime = CACHE_LIFETIME;
	$box_smarty->cache_modified_check = CACHE_CHECK;
	$cache_id = $_SESSION['language'].(int) $_GET['manufacturers_id'];
}

if(!$box_smarty->is_cached(CURRENT_TEMPLATE.'/boxes/box_manufacturers.html', $cache_id) || !$cache)
{
	$box_smarty->assign('tpl_path', 'templates/'.CURRENT_TEMPLATE.'/');

	$manufacturers_query = xtDBquery("SELECT DISTINCT
											m.manufacturers_id,
											m.manufacturers_name
										FROM
											".TABLE_MANUFACTURERS." as m,
											".TABLE_PRODUCTS." as p
										WHERE
											m.manufacturers_id = p.manufacturers_id
										ORDER BY
											m.manufacturers_name");
	if(xtc_db_num_rows($manufacturers_query, true) > 0)
	{
		require_once (DIR_FS_INC.'cseo_get_url_friendly_text.inc.php');
		if (xtc_db_num_rows($manufacturers_query, true) <= MAX_DISPLAY_MANUFACTURERS_IN_A_LIST)
		{
			// Display a list
			$manufacturers_list = '';
			while ($manufacturers = xtc_db_fetch_array($manufacturers_query, true))
			{
				$manufacturers_name = ((strlen($manufacturers['manufacturers_name']) > MAX_DISPLAY_MANUFACTURER_NAME_LEN) ? substr($manufacturers['manufacturers_name'], 0, MAX_DISPLAY_MANUFACTURER_NAME_LEN).'..' : $manufacturers['manufacturers_name']);
				if (isset($_GET['manufacturers_id']) && ($_GET['manufacturers_id'] == $manufacturers['manufacturers_id']))
					$manufacturers_name = '<b>'.$manufacturers_name.'</b>';

				//$manufacturers_list .= '<a href="manufacturer-'.$manufacturers['manufacturers_id'].'/'.cseo_get_url_friendly_text($manufacturers_name).'">'.$manufacturers_name.'</a><br />';
				$manufacturers_list .= '<a href="'.xtc_href_link(FILENAME_DEFAULT, 'manufacturers_id='.$manufacturers['manufacturers_id']).'">'.$manufacturers_name.'</a><br>';
			}
			$box_manufacturers = $manufacturers_list;
		}
		else
		{
			#$dropdown  = '<select name="'.MANUFACTURERS_LINK.'" onchange="this.form.submit();" size="'.MAX_MANUFACTURERS_LIST.'" style="width: 100%">';
			$dropdown  = '<select name="" onchange="window.location.href=this.value" size="'.MAX_MANUFACTURERS_LIST.'" title="'.WCAG_MANUFACTURERS_LABEL.'" id="manufacturerdropdown">';
			$dropdown .= '<option>'.PULL_DOWN_DEFAULT.'</option>';
			while ($manufacturers = xtc_db_fetch_array($manufacturers_query, true))
			{
				$name_raw = ((strlen($manufacturers['manufacturers_name']) > MAX_DISPLAY_MANUFACTURER_NAME_LEN) ? substr($manufacturers['manufacturers_name'], 0, MAX_DISPLAY_MANUFACTURER_NAME_LEN).'..' : $manufacturers['manufacturers_name']);
				//$name_val = cseo_get_url_friendly_text($manufacturers['manufacturers_name']);
				//$dropdown .= '<option value="manufacturer-'.$manufacturers['manufacturers_id'].'/'.$name_val.'">'.$name_raw.'</option>';
				$dropdown .= "<option value='".xtc_href_link(FILENAME_DEFAULT, 'manufacturers_id='.$manufacturers['manufacturers_id'])."'>".$name_raw."</option>";
			}
			$dropdown .= '</select>';
			$box_manufacturers  = xtc_draw_form('manufacturers', DIR_WS_CATALOG, 'GET');
			#$box_manufacturers .= '<label title="'.WCAG_MANUFACTURERS_LABEL.'" for="manufacturerdropdown">'.WCAG_MANUFACTURERS.'</label><br />';
			$box_manufacturers .= $dropdown;
			$box_manufacturers .= '</form>';
		}
		$box_smarty->assign('BOX_CONTENT', $box_manufacturers);
	}
}
if(!$cache)
	$box_content = $box_smarty->fetch(CURRENT_TEMPLATE.'/boxes/box_manufacturers.html');
else
	$box_content = $box_smarty->fetch(CURRENT_TEMPLATE.'/boxes/box_manufacturers.html', $cache_id);
?>